//iPhone Application Programming WS 15/16
//Part of S02 Swift Part 1
//Find more examples in: The Swift Programming Language (Swift 2.1):Collection Types

/* Arrays */


//Access arrays with the subscript syntax
var someInts = [Int](count: 3, repeatedValue: 10)
var someVar = someInts[1]
print( "Value of first element is \(someVar)" )
print( "Value of first element is \(someInts.first!)" )
print( "Value of first element is \(someInts.last!)" )


//Add and remove from arrays
var arrayOfInts = [Int]()

arrayOfInts.append(20) //if it was a let array this would crash
arrayOfInts.append(30)
arrayOfInts += [40, 70]

//Moddify exiting elements
arrayOfInts[2] = 50
//arrayOfInts[4] //out of bounds

arrayOfInts.insert(88, atIndex: 3)

var removeElement = arrayOfInts.removeAtIndex(1)
//also can use removeAll()

arrayOfInts.replaceRange(0..<3, with: [1,2,3,4,5])
arrayOfInts.removeRange(0...2)


//Enumeration and tuples
var someStrs = ["Breakfast", "Lunch", "Dinner"]

for item in someStrs {
    print(item)
}



for (index, item) in someStrs.enumerate() {
    print("Value at index = \(index) is \(item)")
}



//Combining arrays
var intsA = [Int](count:2, repeatedValue: 2)
var intsB = [Int](count:3, repeatedValue: 1)
var intsC = intsA + intsB

intsC.isEmpty
intsC.count



/* Dictionaries */


var someDict:[Int:String] = [1:"One", 2:"Two", 3:"Three"]
//No need got :[Int:String] (type inference)


//Read a value for key
var someValue = someDict[1]

//Modify a value for key
someDict[1] = "Zero"

//Add a key-value
someDict[4] = "Four"

//Remove a key-value
someDict[4] = nil

var removedValue = someDict.removeValueForKey(1)
print(removedValue)



//Iteration
for (key, value) in someDict {
    print("Dictionary key \(key) -  Dictionary value \(value)")
}
//What do you think key and value will be?

//And now? option-click
for (key, value) in someDict.enumerate() {
    print("Dictionary key \(key) -  Dictionary value \(value)")
}

//Count of key-value pairs
someDict.count


let value = someDict[3] //What type is value? Why?
print(value)



//Convert to arrays
let dictKeys = [Int](someDict.keys)
let dictValues = [String](someDict.values)

var anotherDict = [String:String]()
anotherDict.isEmpty





/* Functions */


// func funcname(optionalExternalName localName:Type,...etc) -> any return type including functions, tuples and optionals

func combineValues(value1:Int, _ value2:Int, valueThree value3:Int) -> (_:Int,secondValue:Int, _:Int?)
{
    return (value1,value2,value3)
}
combineValues(10, 20, valueThree:30).secondValue //20

if let thirdValue = combineValues(10, 20, valueThree:30).2 //access tuple by index
{
    print("That was an Optional type in a tuple type")
}


//func funcname(arg1:Type,var arg2:Type, inout arg3:Type...) -> any return type
//let is the deafult, var make it mutable, inout like sending by reference

func manipulateValues(value1:Int, var _ value2:Int, inout valueThree value3:Int, valueFour _:Int) -> (_:Int,secondValue:Int, _:Int, _:Int?)
{
    //value1 += 1
    value2 += 1
    value3 += 1
    return (value1,value2,value3,3)
}


var someValue1 = 2
var anotherValue1 = 3
manipulateValues(1, someValue1, valueThree:&anotherValue1, valueFour:4)
someValue1 //not effected by changes in the function
anotherValue1 //effected by the changes in the function

//Functions of the same type but different external names are considered unique
func power(a: Int, b: Int) -> Int {
    var result = a
    
    for _ in 1..<b {
        result = result * a
    }
    
    return result
}

power(2,b: 3)

func power(base a: Int, exponent b: Int) -> Int {
    var result = a
    
    for _ in 1..<b {
        result = result * a
    }
    
    return result
}
power(base: 2, exponent: 3)


//Variadic parameters take any number of argumnets of the same type. Each function can have at most one variadic parameter and should be at the end of the parameters list
func vari<N>(members: N...){
    for i in members {
        print(i)
    }
}
vari(4,3,5)
vari("four", "three", "five", "six")

//Default values
func addToContactList(name:String,phone:String,list:String = "Friends")
{
    print("New contact "+name+" with phone number: \(phone), was added to list \(list)")
}

addToContactList("Lara", phone: "01234567")
addToContactList("Moe", phone: "76543210", list:"Work")



//Function as a type
func sum(a: Int, b: Int) -> Int {
    return a + b
}

var addition: (Int, Int) -> Int = sum
print("Result: \(addition(40, 89))")

func another(add: (Int, Int) -> Int, a: Int, b: Int) {
    print("Result: \(add(a, b))")
}

another(sum, a: 10, b: 20)


//Nested functions are return type
func calcDecrement(forDecrement total: Int) -> () -> Int {
    var overallDecrement = 0
    func decrementer() -> Int {
        overallDecrement -= total
        return overallDecrement
    }
    return decrementer
}
let decrem30 = calcDecrement(forDecrement: 30)
print(decrem30()) //
let decrem10 = calcDecrement(forDecrement: 10)
print(decrem10())
print(decrem30())









